/*********************************************
 * Tululoo Game Maker v1.2.1
 *
 * Creators 
 * Zoltan Percsich
 * Vadim "YellowAfterlife" Dyachenko
 *
 * (c) SilentWorks 2011
 * All rights reserved.
 * www.tululoo.com
 *
 * Contributors:
 * Csaba Herbut
 ********************************************/

// misc variables:
var mouse_x;
var mouse_y;
var room_current = null;
var room_speed = 30, fps = room_speed;
var room_background = null;
var room_width = 0;
var room_height = 0;
var room_background_color_red = 0;
var room_background_color_green = 0;
var room_background_color_blue = 0;
var room_viewport_width = 0;
var room_viewport_height = 0;
var room_viewport_object = null;
var room_viewport_hborder = 0;
var room_viewport_vborder = 0;
var room_viewport_x = 0;
var room_viewport_y = 0;
// keyboard functions:
function keyboard_check ( _key ) { return key_down[_key]; }
function keyboard_check_pressed ( _key ) { return key_pressed[_key]; }
function keyboard_check_released ( _key ) { return key_released[_key]; }
// mouse functions:
function mouse_check ( ) { return mouse_down; }
function mouse_check_pressed ( ) { return mouse_pressed; }
function mouse_check_released ( ) { return mouse_released; }
// virtual keys:
function vkey() {
	this.top = 0;
	this.left = 0;
	this.right = 0;
	this.bottom = 0;
	this.key = 0;
	this.down = false;
	this.active = true;
}
function vkey_add(_x, _y, _w, _h, _k)
{
	var _v = new vkey();
	_v.left = _x;
	_v.top = _y;
	_v.right = _x + _w;
	_v.bottom = _y + _h;
	_v.width = _w;
	_v.height = _h;
	_v.key = _k;
	tu_vkeys.push(_v);
	return _v;
}
function tu_idle() { } // left empty on purpose
function trace() { return console.log.apply(this, arguments); }
// minimal math:
function abs(_value) { return _value < 0 ? -_value : _value; }
function sign(_value) { return _value > 0 ? 1 : _value < 0 ? -1 : 0; }
function max() { return Math.max.apply(null, arguments); }
function min() { return Math.min.apply(null, arguments); }
function choose() { return arguments[Math.floor( Math.random() * arguments.length )]; }
function random(_value) { return Math.random() * _value; }
function irandom(_value) { return Math.floor( Math.random() * _value + 1 ); }
// trig functions:
function lengthdir_x(_length, _direction) { return _length * Math.cos(_direction * tu_d2r); }
function lengthdir_y(_length, _direction) { return _length * Math.sin(_direction * tu_d2r); }
function point_distance(_x1, _y1, _x2, _y2) { return Math.sqrt(Math.pow(( _x1 - _x2), 2) + Math.pow((_y1 - _y2), 2)); }
function point_direction(_x1, _y1, _x2, _y2) { return Math.atan2(_y2 - _y1, _x2 - _x1) * tu_r2d; }
function degtorad(_degree) { return _degree * tu_d2r; }
function radtodeg(_degree) { return _degree * tu_r2d; }
// sound functions:
function sound_mode(_sound, _mode) {
	if (_sound.audio.networkState == _sound.audio.NETWORK_NO_SOURCE) return;
	switch (_sound.type) {
	case "wav": if (!tu_wav_supported) return; break;
	case "ogg": if (!tu_ogg_supported) return; break;
	case "mp3": if (!tu_mp3_supported) return; break;
	}
	if (_mode != 3) {
		_sound.audio.pause();
		_sound.audio.currentTime = 0;
		if (_mode == 0) return;
		_sound.audio.loop = _mode > 1;
	}
	_sound.audio.play();
}
function sound_play( _sound ) { sound_mode(_sound, 1); }
function sound_loop( _sound ) { sound_mode(_sound, 2); }
function sound_resume( _sound ) { sound_mode(_sound, 3); }
function sound_stop( _sound ) { sound_mode(_sound, 0); }
function sound_stop_all() { for ( var _s = 0; _s < tu_audios.length; _s++ ) sound_stop( tu_audios[_s] ); }
function sound_volume( _sound, _volume ) {
	if (_sound.audio.networkState == _sound.audio.NETWORK_NO_SOURCE) return;
	_sound.audio.volume = _volume;
}
// draw sprite:
function draw_sprite ( _sprite_index, _sub_image, _x, _y ) {
	if (_sprite_index == null) return;
	if ( _sub_image > _sprite_index.frames.length - 1 ) _sub_image = 0;
	tu_context.save();
	tu_context.translate(_x - room_viewport_x, _y - room_viewport_y);
	tu_context.globalAlpha = tu_draw_alpha;
	tu_context.drawImage(_sprite_index.frames[_sub_image >> 0], -_sprite_index.xoffset, -_sprite_index.yoffset);
	tu_context.restore();
}
function draw_sprite_ext ( _sprite_index, _sub_image, _x, _y, _xscale, _yscale, _rotation, _alpha ) {
	if (_sprite_index == null) return;
	if ( _sub_image >= _sprite_index.frames.length ) _sub_image = _sub_image % _sprite_index.frames.length;
	tu_context.save();
	tu_context.translate(_x - room_viewport_x, _y - room_viewport_y);
	tu_context.rotate(degtorad(_rotation));
	tu_context.globalAlpha = _alpha;
	tu_context.drawImage( _sprite_index.frames[_sub_image >> 0], _xscale * -_sprite_index.xoffset , _yscale * -_sprite_index.yoffset, _xscale * _sprite_index.width, _yscale * _sprite_index.height );
	tu_context.restore();
}
// draw text:
function draw_text ( _x, _y, _text ) {
	tu_context.font = tu_draw_font;
	tu_context.textAlign = tu_draw_halign;
	tu_context.textBaseLine = tu_draw_valign;
	tu_context.fillStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.fillText( _text, _x - room_viewport_x, _y - room_viewport_y );
}
// draw shapes:
function draw_rectangle ( _x1, _y1, _x2, _y2, _outline ) {
	tu_context.fillStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	if (_outline) tu_context.strokeRect( _x1- room_viewport_x, _y1 - room_viewport_y, _x2 - _x1, _y2 - _y1 );
	else tu_context.fillRect( _x1- room_viewport_x, _y1 - room_viewport_y, _x2 - _x1, _y2 - _y1 );
	tu_context.closePath();
}
function draw_circle ( _x, _y, _r, _outline ) {
	tu_context.fillStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	tu_context.arc( _x - room_viewport_x, _y - room_viewport_y, _r, 0, 2 * Math.PI, true );
	tu_context.closePath();
	!_outline ? tu_context.fill() : tu_context.stroke();
}

function draw_line ( _x1, _y1, _x2, _y2 ) {
	tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	tu_context.moveTo( _x1 - room_viewport_x, _y1 - room_viewport_y );
	tu_context.lineTo( _x2 - room_viewport_x, _y2 - room_viewport_y );
	tu_context.closePath();
	tu_context.stroke();	
}
// draw settings:
function draw_set_alpha ( _alpha ) {
	tu_draw_alpha = _alpha;
}
function draw_set_color( _r, _g, _b ) {
	tu_draw_color_red = _r;
	tu_draw_color_green = _g;
	tu_draw_color_blue = _b;
	tu_draw_color = tu_draw_color_red + "," + tu_draw_color_green + "," + tu_draw_color_blue;
	tu_context.fillStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.strokeStyle = "rgb(" + tu_draw_color + ")";
}
function draw_set_linewidth( _width ) { tu_context.lineWidth = _width; }
// draw settings - font:
function draw_set_font ( _font ) {
	tu_draw_font = ( _font.bold == 1 ? "bold" : "" ) + " " + ( _font.italic == 1 ? "italic" : "" ) + " " + _font.size + "px " + _font.family;
	tu_context.font = tu_draw_font;
	tu_context.textAlign = tu_draw_halign;
	tu_context.textBaseLine = tu_draw_valign;
}
function draw_set_halign( _halign ) { tu_draw_halign = _halign; }
function draw_set_valign( _valign ) { tu_draw_valign = _valign; }
// room translations:
function room_goto( _scene ) {
	tu_viewport_inst = null;
	tu_room_to_go = _scene;
}
function room_goto_next( ) {
	var _ri = 0;
	for (var _r = 0; _r < tu_scenes.length; _r++) if (tu_scenes[_r] == room_current) _ri = _r;
	if (typeof tu_scenes[(_ri + 1)] == "object") room_goto(tu_scenes[_ri + 1]);
}
function room_goto_previous( ) {
	var _ri = 0;
	for (var _r = 0; _r < tu_scenes.length; _r++) if (tu_scenes[_r] == room_current) _ri = _r;
	if (typeof tu_scenes[(_ri - 1)] == "object") room_goto(tu_scenes[_ri - 1]);
}
function room_goto_first( ) { room_goto(tu_scenes[0]); }
function room_goto_last( ) { room_goto(tu_scenes[(tu_scenes.length - 1)]); }
function room_restart() { room_goto(room_current); }
// instance functions:
function instance_create( _x, _y, _object ) {
	tu_obj = new _object.constructor;
	tu_obj.object_index = _object;
	tu_obj.x = _x;
	tu_obj.y = _y;
	tu_obj.xstart = _x;
	tu_obj.ystart = _y;
	tu_type_add(tu_obj._object_index, tu_obj);
	if (tu_obj.parent != null) tu_type_add(tu_obj.parent, tu_obj);
	tu_obj.depth = tu_obj.depthstart;
	tu_obj.parent != null && tu_obj.creation_overwritten == 0 ? tu_obj.parent.__creation__.call(tu_obj) : tu_obj.__creation__();
	//if ( room_viewport_object == _object ) tu_viewport_inst = null;
	return tu_obj;
}
function instance_number( _object ) {
	return instance_list(_object).length;
}
// instance collision checking:
function position_meeting ( _x, _y, _object ) {
	var _o, _s, _q = instance_list(_object);
	for (var _i = 0, _il = _q.length; _i < _il; _i++) {
		_o = _q[_i];
		_s = _o.sprite_index;
		if (!_o.collision_checking) continue;
		if (_o == this) continue;
		switch (_s.collision_shape)
		{
		case "Box":
			if (_x < _o.x + _o.image_xscale * (_s.collision_left - _s.xoffset)) break;
			if (_x >= _o.x + _o.image_xscale * (_s.collision_right - _s.xoffset)) break;
			if (_y < _o.y + _o.image_yscale * (_s.collision_top - _s.yoffset)) break;
			if (_y >= _o.y + _o.image_yscale * (_s.collision_bottom - _s.yoffset)) break;
			return _o;
		case "Circle":
			var _r = _s.collision_radius * Math.max(_o.image_xscale, _o.image_yscale);
			var _dx = _o.x + (_s.width / 2 - _s.xoffset) - _x;
			var _dy = _o.y + (_s.height / 2 - _s.yoffset) - _y;
			if ((_dx * _dx) + (_dy * _dy) > _r * _r) break;
			return true;
		}
	}
	return false;
}

function instance_position( _x, _y, _object ) {
	var _o, _s, _q = instance_list(_object);
	for (var _i = 0, _il = _q.length; _i < _il; _i++) {
		_o = _q[_i];
		_s = _o.sprite_index;
		if (!_o.collision_checking) continue;
		if (_o == this) continue;
		switch (_s.collision_shape)
		{
		case "Box":
			if (_x < _o.x + _o.image_xscale * (_s.collision_left - _s.xoffset)) break;
			if (_x >= _o.x + _o.image_xscale * (_s.collision_right - _s.xoffset)) break;
			if (_y < _o.y + _o.image_yscale * (_s.collision_top - _s.yoffset)) break;
			if (_y >= _o.y + _o.image_yscale * (_s.collision_bottom - _s.yoffset)) break;
			return _o;
		case "Circle":
			var _r = _s.collision_radius * Math.max(_o.image_xscale, _o.image_yscale);
			var _dx = _o.x + (_s.width / 2 - _s.xoffset) - _x;
			var _dy = _o.y + (_s.height / 2 - _s.yoffset) - _y;
			if ((_dx * _dx) + (_dy * _dy) > _r * _r) break;
			return _o;
		}
	}
	return null;
}
// web data:
function save_web_data( _name, _value ) { window.localStorage.setItem( _name, _value ); }
function save_web_integer( _name, _value ) { window.localStorage.setItem( "int_" + _name, _value ); }
function save_web_float( _name, _value ) { window.localStorage.setItem( "float_" + _name, _value ); }
function save_web_string( _name, _value ) { window.localStorage.setItem( "string_" + _name, _value ); }
function load_web_data( _name ) { return window.localStorage.getItem( _name ); }
function load_web_integer( _name ) { return parseInt( window.localStorage.getItem( "int_" + _name ) ); }
function load_web_float( _name ) { return parseFloat( window.localStorage.getItem( "float_" + _name ) ); }
function load_web_string( _name ) { return window.localStorage.getItem( "string_" + _name ); }
function delete_web_data( _name ) { window.localStorage.removeItem( _name ); }
function delete_web_integer( _name ) { window.localStorage.removeItem( "int_" + _name ); }
function delete_web_string( _name ) { window.localStorage.removeItem( "float_" + _name ); }
function delete_web_string( _name ) { window.localStorage.removeItem( "string_" + _name ); }
function clear_web_data() { window.localStorage.clear(); }
function web_data_number() { return window.localStorage.length; }
// misc functions:
function pause_game( _key ) {
	tu_paused = true;
	tu_unpausekey = _key;
}
function show_mouse() { tu_canvas.style.cursor = "default"; }
function hide_mouse() { tu_canvas.style.cursor = "none"; }

/***********************************************************************
 * ENGINE
 ***********************************************************************/
var tu_sprites = []; // tu_sprites
var tu_audios = [];
var tu_backgrounds = [];
var tu_fonts = [];
var tu_depth = [];
var tu_depthi = [];
var tu_types = [];
var tu_scenes = []; // tu_scenes
var key_down = [], key_pressed = [], key_released = [], tu_vkeys = [];
var mouse_down = false, mouse_pressed = false, mouse_released = false;
var tu_wav_supported = false, tu_ogg_supported = false, tu_mp3_supported = false;
var tu_canvas = null, tu_context = null;
var tu_frame_time = 0, tu_frame_step = 0, tu_frame_el = 0, tu_frame_count = 0, tu_elapsed;
var tu_prev_frame_time = 0;
var tu_draw_alpha = 1;
var tu_draw_font = "Arial 12px";
var tu_draw_color_red = 0, tu_draw_color_green = 0, tu_draw_color_blue = 0;
var tu_draw_color = "rgb(" + tu_draw_color_red + "," + tu_draw_color_green + "," + tu_draw_color_blue + ")";
var tu_draw_halign = "left", tu_draw_valign = "top";
var tu_loading = 0, tu_load_total = 0;
var tu_keys_pressed = [];
var tu_keys_released = [];
var tu_viewport_inst = null;
var tu_room_to_go = null;
var tu_paused = false;
var tu_unpausekey = 27;
var pi_div180 = Math.PI / 180;
var tu_r2d = -180 / Math.PI;
var tu_d2r = Math.PI / -180;
var tu_2pi = Math.PI * 2;
//
var vk_0 = 48, vk_1 = 49, vk_2 = 50, vk_3 = 51, vk_4 = 52, vk_5 = 53, vk_6 = 54;
var vk_7 = 55, vk_8 = 56, vk_9 = 57, vk_a = 65, vk_add = 107, vk_alt = 18, vk_b = 66;
var vk_backspace = 8, vk_c = 67, vk_ctrl = 17, vk_d = 68, vk_decimal = 110, vk_delete = 46;
var vk_divide = 111, vk_down = 40, vk_e = 69, vk_end = 35, vk_enter = 13, vk_escape = 27;
var vk_f1 = 112, vk_f2 = 113, vk_f3 = 114, vk_f4 = 115, vk_f5 = 116, vk_f6 = 117;
var vk_f7 = 118, vk_f8 = 119, vk_f9 = 120, vk_f10 = 121, vk_f11 = 122, vk_f12 = 123;
var vk_g = 71, vk_h = 72, vk_home = 36, vk_f = 70;
var vk_i = 73, vk_insert = 45, vk_j = 74, vk_k = 75, vk_l = 76, vk_left = 37, vk_m = 77;
var vk_multiply = 106, vk_n = 78, vk_num0 = 96, vk_num1 = 97, vk_num2 = 98, vk_num3 = 99;
var vk_num4 = 100, vk_num5 = 101, vk_num6 = 102, vk_num7 = 103, vk_num8 = 104, vk_num9 = 105;
var vk_o = 79, vk_p = 80, vk_pagedown = 34, vk_pageup = 33, vk_pause = 19, vk_q = 81
var vk_r = 82, vk_right = 39, vk_s = 83, vk_shift = 16, vk_space = 32, vk_subtract = 109;
var vk_t = 84, vk_tab = 9, vk_u = 85, vk_up = 38, vk_v = 86, vk_w = 87, vk_x = 88;
var vk_y = 89, vk_z = 90;

var fa_left = "left", fa_center = "center", fa_right = "right";
var fa_top = "top", fa_middle = "middle", fa_bottom = "bottom";
 
function __global__ () { }
global = new __global__();
 
function tu_detect_audio_wav () {
	var _a = document.createElement('audio');
	return !!(_a.canPlayType && _a.canPlayType('audio/wav; codecs="1"').replace(/no/, ''));	
};
	
function tu_detect_audio_ogg () {
	var _a = document.createElement('audio');
	return !!(_a.canPlayType && _a.canPlayType('audio/ogg; codecs="vorbis"').replace(/no/, ''));
};
	
function tu_detect_audio_mp3 () {
	var _a = document.createElement('audio');
	return !!(_a.canPlayType && _a.canPlayType('audio/mpeg;').replace(/no/, ''));	
};
	
function __keydownlistener__ ( _e ) {
	var keyCode = ( window.event ) ? _e.which : _e.keyCode;
	if (!key_down[keyCode])
	{
		key_pressed[keyCode] = true;
		tu_keys_pressed.push(keyCode);
	}
	key_down[keyCode] = true;
};
	
function __keyuplistener__ ( _e ) {
	var keyCode = ( window.event ) ? _e.which : _e.keyCode;
	if ( key_down[keyCode])
	{
		key_released[keyCode] = true;
		tu_keys_released.push(keyCode);
	}
	key_down[keyCode] = false;
};
	
function __mousemovelistener__ ( _e ) {
	if ( _e.pageX != undefined && _e.pageY != undefined ) {
		mouse_x = _e.pageX;
		mouse_y = _e.pageY;
	} else {
		mouse_x = _e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		mouse_y = _e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	if ( room_current != null ) {
		mouse_x -= tu_canvas.offsetLeft;
		mouse_y -= tu_canvas.offsetTop;			
	}
};
	
function __mousedownlistener__ ( _e ) {
	if (!mouse_down) mouse_pressed = true;
	mouse_down = true;
};
	
function __mouseuplistener__ ( _e ) {
	if (mouse_down) mouse_released = true;
	mouse_down = false;
};

function __touchvkey__(_t) {
	var _tx = 0, _ty = 0, _tc = 0;
	var _tl = _t.length;
	var _vl = tu_vkeys.length;
	var _i, _j, _c, _k;
	var _dx = tu_canvas.offsetLeft;
	var _dy = tu_canvas.offsetTop;
	for (_i = 0; _i < _vl; _i++) tu_vkeys[_i].count = 0;
	for (_i = 0; _i < _tl; _i++)
	{
		_c = 0;
		for (_j = 0; _j < _vl; _j++)
		{
			if (!tu_vkeys[_j].active) continue;
			if (_t[_i].pageX - _dx > tu_vkeys[_j].right) continue;
			if (_t[_i].pageX - _dx < tu_vkeys[_j].left) continue;
			if (_t[_i].pageY - _dy < tu_vkeys[_j].top) continue;
			if (_t[_i].pageY - _dy > tu_vkeys[_j].bottom) continue;
			tu_vkeys[_j].count++;
			if (!tu_vkeys[_j].down)
			{
				tu_vkeys[_j].down = true;
				_k = tu_vkeys[_j].key;
				if (!key_down[_k])
				{
					key_down[_k] = true;
					tu_pressed[_k] = true;
					tu_keys_pressed.push(_k);
				}
			}
			_c++;
		}
		if (_c == 0)
		{
			_tx += _t[_i].pageX;
			_ty += _t[_i].pageY;
			_tc++;
		}
	}
	for (_i = 0; _i < _vl; _i++)
	{
		if (tu_vkeys[_i].count != 0) continue;
		if (!tu_vkeys[_i].down) continue;
		tu_vkeys[_i].down = false;
		_k = tu_vkeys[_i].key;
		if (key_down[_k])
		{
			key_down[_k] = false;
			key_released[_k] = true;
			tu_keys_released.push(_k);
		}
	}
	if (_tc != 0)
	{
		mouse_x = (_tx / _tc) - _dx;
		mouse_y = (_ty / _tc) - _dy;
	} else if (mouse_down) {
		mouse_down = mouse_pressed = mouse_released = false;
	}
};

function __touchstartlistener__ ( _e ) {
	_e.preventDefault();
	if (!mouse_down) mouse_pressed = true;
	mouse_down = true;
	__touchvkey__(_e.targetTouches);
};

function __touchendlistener__ ( _e ) {
	_e.preventDefault();
	if (mouse_down) mouse_released = true;
	mouse_down = false;
	__touchvkey__(_e.targetTouches);
};

function __touchmovelistener__ ( _e ) {
	_e.preventDefault();
	__touchvkey__(_e.targetTouches);
};

function __place_meeting__ ( _x, _y, _object ) {
	this.other = null;
	if (!this.collision_checking) return;
	var _ts = this.sprite_index;
	if (_ts == null) return;
	var _tl = _x + this.image_xscale * (_ts.collision_left - _ts.xoffset);
	var _tr = _x + this.image_xscale * (_ts.collision_right - _ts.xoffset);
	var _tt = _y + this.image_yscale * (_ts.collision_top - _ts.yoffset);
	var _tb = _y + this.image_yscale * (_ts.collision_bottom - _ts.yoffset);
	var _tx = _x + this.image_xscale * (_ts.width / 2 - _ts.xoffset);
	var _ty = _y + this.image_yscale * (_ts.height / 2 - _ts.yoffset);
	var _td = _ts.collision_radius * Math.max(this.image_xscale, this.image_yscale);
	var _tz = instance_list(_object);
	for (var _i = 0, _l = _tz.length; _i < _l; _i++) {
		var _o = _tz[_i];
		var _os = _o.sprite_index;
		if (_os == null) continue;
		if (!_o.collision_checking) continue;
		if (_o == this) continue;
		var _to = _ts.collision_shape + _os.collision_shape;
		switch(_to)
		{
		case "BoxBox":
			if (_tb <= _o.y + _o.image_yscale * (_os.collision_top - _os.yoffset)) break;
			if (_tt >= _o.y + _o.image_yscale * (_os.collision_bottom - _os.yoffset)) break;
			if (_tr <= _o.x + _o.image_xscale * (_os.collision_left - _os.xoffset)) break;
			if (_tl >= _o.x + _o.image_xscale * (_os.collision_right - _os.xoffset)) break;
			this.other = _o;
			_o.other = this;
			return _o;
		case "BoxCircle":
			var _or = _os.collision_radius * Math.max(_o.image_xscale, _o.image_yscale);
			var _ox = _o.x + _o.image_xscale * (_os.width / 2 - _os.xoffset);
			var _oy = _o.y + _o.image_yscale * (_os.height / 2 - _os.yoffset);
			if (_tl - _ox >= _or) break;
			if (_ox - _tr >= _or) break;
			if (_tt - _oy >= _or) break;
			if (_oy - _tb >= _or) break;
			this.other = _o;
			_o.other = this;
			return _o;
		case "CircleBox":
			if (_td + _tx <= _o.x + _o.image_xscale * (_os.collision_left - _os.xoffset)) break;
			if (_tx - _td >= _o.x + _o.image_xscale * (_os.collision_right - _os.xoffset)) break;
			if (_td + _ty <= _o.y + _o.image_yscale * (_os.collision_top - _os.yoffset)) break;
			if (_ty - _td >= _o.y + _o.image_yscale * (_os.collision_bottom - _os.yoffset)) break;
			this.other = _o;
			_o.other = this;
			return _o;
		case "CircleCircle":
			var _or = _os.collision_radius * Math.max(_o.image_xscale, _o.image_yscale);
			var _ox = _o.x + _o.image_xscale * (_os.width / 2 - _os.xoffset);
			var _oy = _o.y + _o.image_yscale * (_os.height / 2 - _os.yoffset);
			if ((_tx - _ox) * (_tx - _ox) + (_ty - _oy) * (_ty - _oy) > (_td + _or) * (_td + _or)) break;
			this.other = _o;
			_o.other = this;
			return _o;
		default:
		}
	}
	return null;
}

function __move_towards_point__( _x, _y, _speed ) {

	if ( _speed != 0 ) {
	
		var _dir = Math.atan2( _y - this.y, this.x - _x ) * ( 180 / Math.PI );
		var _dist = Math.sqrt( Math.pow( ( this.x - _x ), 2 ) + Math.pow( ( this.y - _y ), 2 ) );
		
		if ( _speed > _dist ) _speed = _dist;
		if ( _dist > 0 ) {
			this.x += _speed * Math.cos( ( _dir - 180 ) * pi_div180 );
			this.y += -_speed * Math.sin( ( _dir - 180 ) * pi_div180 );
		}
	}
}

function __instance_destroy__() {
	tu_trash.push( this );
}

function tu_init () {
	
	if ( document.addEventListener ) {
		document.addEventListener( "keydown", __keydownlistener__, false );
		document.addEventListener( "keyup", __keyuplistener__, false );
		document.addEventListener( "mousemove", __mousemovelistener__, false );
		document.addEventListener( "mousedown", __mousedownlistener__, false );
		document.addEventListener( "mouseup", __mouseuplistener__, false );
		document.addEventListener( "touchstart", __touchstartlistener__, false );
		document.addEventListener( "touchend", __touchendlistener__, false );
		document.addEventListener( "touchmove", __touchmovelistener__, false );
	} else {
		document.attachEvent( "onkeydown", __keydownlistener__ );
		document.attachEvent( "onkeyup", __keyuplistener__ );
		document.attachEvent( "onmousemove", __mousemovelistener__ );
		document.attachEvent( "onmousedown", __mousedownlistener__ );
		document.attachEvent( "onmouseup", __mouseuplistener__ );
	}
	// initialize keycodes
	for ( var _k = 0; _k < 256; _k++ ) {
		key_down[_k] = false;
		key_pressed[_k] = false;
		key_released[_k] = false;
	}
	// detect supported audio formats
	tu_wav_supported = tu_detect_audio_wav();
	tu_ogg_supported = tu_detect_audio_ogg();
	tu_mp3_supported = tu_detect_audio_mp3();
}

function _$_( _id_ ) {
	return document.getElementById( _id_ );
}

var var_override_ = (Object.defineProperty != undefined);
function var_override(_what, _svar, _fget, _fset) {
	if (var_override_)
	{
		if (_what.hasOwnProperty(_svar)) return;
		Object.defineProperty(_what, _svar, {
			get: _fget,
			set: _fset
		});
	} else {
		if (_what.__lookupGetter__(_svar) != undefined) return;
		_what.__defineGetter__(_svar, _fget);
		_what.__defineSetter__(_svar, _fset);
	}
}

// depth methods:
function _tu_depth_find(_d) {
	var _tl = tu_depthi.length;
	var _td;
	for (var _ti = 0; _ti < _tl; _ti++)
	{
		_td = tu_depthi[_ti];
		if (_d > _td) return _ti;
	}
	return _tl;
}
function _tu_depth_new(_d) {
	var _i = _tu_depth_find(_d);
	var _o = [];
	tu_depth.splice(_i, 0, _o);
	tu_depthi.splice(_i, 0, _d);
	return _i;
}
function tu_depth_add(_d, _o) {
	var _t = tu_depthi.indexOf(_d);
	if (_t == -1) _t = _tu_depth_new(_d); // create array if none
	tu_depth[_t].push(_o);
}
function tu_depth_delete(_d, _o) {
	var _t = tu_depth[tu_depthi.indexOf(_d)];
	var _ti = _t.indexOf(_o);
	if (_ti == -1) return;
	_t.splice(_ti, 1);
}
function tu_depth_set(_d) {
	if (this._depth == _d) return; // don't change on depth match
	if (this._depth != undefined) tu_depth_delete(this._depth, this);
	this._depth = _d;
	if (this._depth != undefined) tu_depth_add(this._depth, this);
}
function tu_depth_get() { return this._depth; }
// type methods:
function instance_list(_o) {
	var _t = _o._object_index_;
	if (tu_types[_t] == undefined) tu_types[_t] = [];
	return tu_types[_t];
}
function tu_type_add(_d, _o) {
	instance_list(_d).push(_o);
}
function tu_type_delete(_o, _p) {
	var _d = tu_types[_p];
	var _t = _d.indexOf(_o);
	_d.splice(_t, 1);
}
function tu_type_get() { return this._object_index; }
//
var tu_tiles = [];
var tu_tilesi = [];
var tu_tilez = 256;
function tile_layer_find(_d) {
	var _tl = tu_tilesi.length;
	var _td;
	for (var _ti = 0; _ti < _tl; _ti++)
	{
		_td = tu_tilesi[_ti];
		if (_d > _td) return _ti;
	}
	return _tl;
}
function tile_layer_add(_d) {
	var _i = tile_layer_find(_d);
	var _o = [];
	tu_tiles.splice(_i, 0, _o);
	tu_tilesi.splice(_i, 0, _d);
	return _o;
}
function tile(_s, _x, _y, _l, _t, _w, _h) {
	this.source = _s;
	this.x = _x;
	this.y = _y;
	this.left = _l;
	this.top = _t;
	this.width = _w;
	this.height = _h;
	this.width2 = _w;
	this.height2 = _h;
	this.sectors = [];
}
function tile_add(_b, _l, _t, _w, _h, _x, _y, _z) {
	var _tx1 = Math.floor(_x / tu_tilez);
	var _ty1 = Math.floor(_y / tu_tilez);
	var _tx2 = Math.floor((_x + _w) / tu_tilez);
	var _ty2 = Math.floor((_y + _h) / tu_tilez);
	var _tt = new tile(_b, _x, _y, _l, _t, _w, _h);
	var _tx, _ty, _ts;
	var _d, _e = tu_tilesi.indexOf(_z);
	if (_e != -1) _d = tu_tiles[_e];
	else _d = tile_layer_add(_z);
	for (_tx = _tx1; _tx <= _tx2; _tx++)
	{
		if (_d[_tx] == null) _d[_tx] = [];
		for (_ty = _ty1; _ty <= _ty2; _ty++)
		{
			if (_d[_tx][_ty] == null) _d[_tx][_ty] = [];
			_ts = _d[_tx][_ty];
			_ts.push(_tt);
			_tt.sectors.push(_ts);
		}
	}
	return _tt;
}
function tile_find(_x, _y, _w, _h, _d) {
	var _xw = _x + _w;
	var _yh = _y + _h;
	var _r = [];
	if (tu_tiles[_d] == null) return _r;
	var _tx1 = Math.floor(_x / tu_tilez);
	var _ty1 = Math.floor(_y / tu_tilez);
	var _tx2 = Math.floor((_x + _w) / tu_tilez);
	var _ty2 = Math.floor((_y + _h) / tu_tilez);
	var _tx, _ty, _ti, _tl, _ts, _tt;
	for (_tx = _tx1; _tx <= _tx2; _tx++)
	{
		if (tu_tiles[_d][_tx] == null) continue;
		for (_ty = _ty1; _ty <= _ty2; _ty++)
		{
			if (tu_tiles[_d][_tx][_ty] == null) continue;
			_ts = tu_tiles[_d][_tx][_ty];
			_tl = _ts.length;
			for (_ti = 0; _ti < _tl; _ti++)
			{
				_tt = _ts[_ti];
				if (_tt.x >= _xw) continue;
				if (_tt.y >= _yh) continue;
				if (_tt.x + _tt.width2 < _x) continue;
				if (_tt.y + _tt.height2 < _y) continue;
				_r.push(_tt);
			}
		}
	}
	return _r;
}
function tile_delete(_t) {
	var _ti, _tl, _tt, _ts;
	_tl = _t.sectors.length;
	for (_ti = 0; _ti < _tl; _ti++)
	{
		_ts = _t.sectors[_ti];
		_ts.splice(_ts.indexOf(_t), 1);
	}
}
function tile_srender(_s) {
	var _ti, _tt;
	for (_ti = 0; _ti < _s.length; _ti++)
	{
		if (_s[_ti] == null) continue;
		_tt = _s[_ti];
		if (_tt.source == null) continue;
		if (_tt.source.image == null) continue;
		tu_context.drawImage(_tt.source.image, _tt.left, _tt.top, _tt.width, _tt.height, _tt.x - room_viewport_x, _tt.y - room_viewport_y, _tt.width2, _tt.height2);
	}
}
function tile_lrender(_l) {
	var _tx, _ty;
	var _tx1 = Math.floor(room_viewport_x / tu_tilez);
	var _tx2 = Math.floor((room_viewport_x + room_viewport_width) / tu_tilez);
	var _ty1 = Math.floor(room_viewport_y / tu_tilez);
	var _ty2 = Math.floor((room_viewport_y + room_viewport_height) / tu_tilez);
	for (_tx = _tx1; _tx <= _tx2; _tx++)
	{
		if (_l[_tx] == null) continue;
		for (_ty = _ty1; _ty <= _ty2; _ty++)
		{
			if (_l[_tx][_ty] == null) continue;
			tile_srender(_l[_tx][_ty]);
		}
	}
}
//
function image_single_get() { return (this.image_speed == 0 ? this.image_index : -1); }
function image_single_set(_o) { this.image_speed = 0; this.image_index = _o; }
//

// instance_init(this, object_index, parent_index, visible, depth, sprite, collideable, inner index)
function __instance_init__(_this, _oi, _p, _v, _d, _si, _c, _io) {
	_this._object_index = undefined;
	_this._object_index_ = _io;
	_this._depth = undefined;
	var_override(_this, 'depth', tu_depth_get, tu_depth_set );
	var_override(_this, 'object_index', tu_type_get, function(){} );
	var_override(_this, 'image_single', image_single_get, image_single_set );
	_this.id = _this;
	_this._object_index = _oi;
	_this.parent = _p;
	_this.x = 0;
	_this.y = 0;
	_this.xprevious = 0;
	_this.yprevious = 0;
	_this.xstart = 0;
	_this.ystart = 0;
	_this.depthstart = _d;
	_this.direction = 0;
	_this.visible = _v;
	_this.image_xscale = 1;
	_this.image_yscale = 1;
	_this.image_angle = 0;
	_this.image_alpha = 1;
	_this.image_index = 0;
	_this.image_speed = 1;
	_this.sprite_index = _si;
	_this.speed = 0;
	_this.other = null;
	_this.collision_checking = _c;
	// shortcuts
	_this.place_meeting = __place_meeting__;
	_this.move_towards_point = __move_towards_point__;
	_this.instance_destroy = __instance_destroy__;
}

function __handle_sprite__( _object_ ) {
	if (_object_.sprite_index == null) return;
	_object_.sprite_width = _object_.sprite_index.width;
	_object_.sprite_height = _object_.sprite_index.height;
	_object_.sprite_xoffset = _object_.sprite_index.xoffset;
	_object_.sprite_yoffset = _object_.sprite_index.yoffset;
	_object_.image_number = _object_.sprite_index.frames.length;
	_object_.image_index += _object_.image_speed;
	if (_object_.image_index >= _object_.image_number) _object_.image_index = _object_.image_index % _object_.image_number;
	if (_object_.image_index < 0) _object_.image_index = _object_.image_number - 1 + (_object_.image_index % _object_.image_number);
}

function tu_preloader() {
	var _w = Math.min(400, (tu_canvas.width * 0.6) >> 0), _h = 16;
	var _x = (tu_canvas.width - _w) >> 1, _y = (tu_canvas.height - _h) >> 1;
	var _p = (tu_load_total - tu_loading) / tu_load_total;
	var _s = "Loading resources: " + (tu_load_total - tu_loading) + "/" + (tu_load_total);
	tu_canvas.width = tu_canvas.width;
	tu_canvas.height = tu_canvas.height;
	tu_canvas.style.backgroundColor = "rgb(42, 42, 42)";
	tu_context.font = "italic 12px Verdana";
	tu_context.textAlign = "left";
	tu_context.textBaseline = "bottom";
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(192, 192, 192, 1)";
	tu_context.fillRect(_x - 1, _y - 1, _w + 2, _h + 2);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(0, 0, 0, 1)";
	tu_context.fillRect(_x, _y, _w, _h);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(255, 255, 255, 1)";
	tu_context.fillRect(_x + 2, _y + 2, (_w - 4) * _p, _h - 4);
	tu_context.fillText(_s, _x, _y - 2);
}

function tu_render_back() {

	if (room_background == null) return;
	if (room_background_tile_stretch)
	{
		tu_context.drawImage(room_background, 0 - room_viewport_x, 0 - room_viewport_y, room_width, room_height);
		return;
	}
	var _x1 = room_background_tile_x ? Math.floor(room_viewport_x / room_background.width) * room_background.width : 0;
	var _x2 = room_background_tile_x ? Math.ceil((room_viewport_x + room_viewport_width) / room_background.width) * room_background.width : _x1 + room_background.width;
	var _y1 = room_background_tile_y ? Math.floor(room_viewport_y / room_background.height) * room_background.height : 0;
	var _y2 = room_background_tile_y ? Math.ceil((room_viewport_y + room_viewport_height) / room_background.height) * room_background.height : _y1 + room_background.height;
	for (var _ht = _x1; _ht < _x2; _ht += room_background.width)
	for (var _vt = _y1; _vt < _y2; _vt += room_background.height)
	tu_context.drawImage(room_background, _ht - room_viewport_x, _vt - room_viewport_y);
}

function tu_render() {

	tu_frame_step = 0;
	// object step events:
	tu_trash = [];
	for (tu_depthd in tu_depth) {
		tu_depthc = tu_depth[tu_depthd];
		for (var tu_deptho = 0, tu_depthl = tu_depthc.length; tu_deptho < tu_depthl; tu_deptho++) {
			var _obj_ = tu_depthc[tu_deptho];
			// is viewport object?
			if (room_viewport_object != null && tu_viewport_inst == null && (_obj_.object_index == room_viewport_object || _obj_.parent == room_viewport_object)) {
				tu_viewport_inst = _obj_;
			}
			// step events:
			_obj_.parent != null && _obj_.step_overwritten == 0 ? _obj_.parent.__step__.call(_obj_) : _obj_.__step__();
			// move object:
			if (_obj_.speed != 0) {
				var _objd_ = _obj_.direction * tu_d2r;
				_obj_.x += _obj_.speed * Math.cos(_objd_);
				_obj_.y += _obj_.speed * Math.sin(_objd_);
			}
			// post-step events:
			_obj_.parent != null && _obj_.collision_overwritten == 0 ? _obj_.parent.__collision__.call(_obj_) : _obj_.__collision__();
			_obj_.parent != null && _obj_.end_step_overwritten == 0 ? _obj_.parent.__end_step__.call(_obj_) : _obj_.__end_step__();
			// post:
			_obj_.xprevious = _obj_.x;
			_obj_.yprevious = _obj_.y;
		}
	}
	// follow object
	if ( tu_viewport_inst != null ) {
		var _h = Math.min(room_viewport_hborder, room_viewport_width / 2);
		var _v = Math.min(room_viewport_vborder, room_viewport_height / 2);
		// hborder:
		if (tu_viewport_inst.x < room_viewport_x + _h) room_viewport_x = tu_viewport_inst.x - _h;
		if (tu_viewport_inst.x > room_viewport_x + room_viewport_width - _h) room_viewport_x = tu_viewport_inst.x - room_viewport_width + _h;
		// vborder:
		if (tu_viewport_inst.y < room_viewport_y + _v) room_viewport_y = tu_viewport_inst.y - _v;
		if (tu_viewport_inst.y > room_viewport_y + room_viewport_height - _v) room_viewport_y = tu_viewport_inst.y - room_viewport_height + _v;
		// limits:
		room_viewport_x = Math.max(0, Math.min(room_viewport_x, room_width - room_viewport_width)) >> 0;
		room_viewport_y = Math.max(0, Math.min(room_viewport_y, room_height - room_viewport_height)) >> 0;
	}
	// clear canvas:
	tu_canvas.width = tu_canvas.width;
	tu_canvas.height = tu_canvas.height;
	// set background color:
	tu_canvas.style.backgroundColor = "rgb(" + room_background_color_red + "," + room_background_color_green + "," + room_background_color_blue + ")";
	tu_render_back();
	tile_layer_last = 0;
	for (tu_depthd in tu_depth) {
		tu_depthc = tu_depth[tu_depthd];
		tu_depthv = tu_depthi[tu_depthd];
		for (; tu_tilesi[tile_layer_last] >= tu_depthv && tile_layer_last < tu_tiles.length; tile_layer_last++)
		{
			tile_lrender(tu_tiles[tile_layer_last]);
		}
		for (var tu_deptho = 0, tu_depthl = tu_depthc.length; tu_deptho < tu_depthl; tu_deptho++) {
			var _obj_ = tu_depthc[tu_deptho];
			_obj_.parent != null && _obj_.draw_overwritten == 0 ? _obj_.parent.__draw__.call(_obj_) : _obj_.__draw__();
			_obj_.parent != null && _obj_.animation_end_overwritten == 0 ? _obj_.parent.__animationend__.call(_obj_) : _obj_.__animationend__();
		}
	}
	for (; tile_layer_last < tu_tiles.length; tile_layer_last++)
	{
		tile_lrender(tu_tiles[tile_layer_last]);
	}
	// clear mouse states and keypressed / keyrelesed statuses
	mouse_pressed = false;
	mouse_released = false;
	for ( var _k = 0; _k < tu_keys_pressed.length; _k++ ) key_pressed[tu_keys_pressed[_k]] = false;
	for ( var _k = 0; _k < tu_keys_released.length; _k++ ) key_released[tu_keys_released[_k]] = false;
	tu_keys_pressed = [];
	tu_keys_released = [];
	// remove objects from destroy stack
	for ( var _r = 0; _r < tu_trash.length; _r++ ) {
		var _obj_ = tu_trash[_r];
		_obj_.depth = undefined;
		tu_type_delete(_obj_, _obj_._object_index_);
		if (_obj_.parent != null) tu_type_delete(_obj_, _obj_.parent._object_index_);
		_obj_.parent != null && _obj_.destroy_overwritten == 0 ? _obj_.parent.__destroy__.call(_obj_) : _obj_.__destroy__();
	}
}

function tu_loop() {
	// calculate render time
	tu_frame_time = (new Date()).getTime();
	tu_elapsed = (tu_frame_time - tu_prev_frame_time);
	tu_frame_step += tu_elapsed;
	tu_frame_el += tu_elapsed;
	// start next room, if any
	if ( tu_room_to_go != null ) {
		room_current = tu_room_to_go;
		tu_room_to_go = null;
		room_current.start();
	}
	// continue game with the UN-Pause key
	if (tu_paused && keyboard_check_pressed( tu_unpausekey )) tu_paused = false;
	// render game:
	if ( tu_frame_step >= 1000 / room_speed && tu_loading == 0 && tu_canvas != null && !tu_paused ) {
		tu_frame_count++;
		tu_render();
	} else if (tu_loading > 0) tu_preloader();
	// calculate fps:
	if (tu_frame_el >= Math.floor(200 / room_speed) * 5 * room_speed)
	{
		fps = Math.ceil(tu_frame_count * 1000 / tu_frame_el);
		tu_frame_el = tu_frame_count = 0;
	}
	// repeat
	tu_prev_frame_time = tu_frame_time;
	setTimeout(__gameloop__, 5);
}
tu_init();

/***********************************************************************
 * EXTENSIONS
 ***********************************************************************/


/***********************************************************************
 * SPRITES
 ***********************************************************************/
function __spr_player() { 
this.frames = [];
var tu_frame = new Image();
tu_loading++;
tu_load_total++;
tu_frame.onload = function() {tu_loading--;};
tu_frame.onerror = function() {tu_loading--;};
tu_frame.src = 'spr_player_0.png';
this.frames.push(tu_frame);
this.width = 40;
this.height = 40;
this.xoffset = 20;
this.yoffset = 20;
this.collision_shape = 'Circle';
this.collision_radius = 16;
this.collision_left = 0;
this.collision_right = 40;
this.collision_top = 0;
this.collision_bottom = 40;
};
var spr_player = new __spr_player();
tu_sprites.push(spr_player);
function __spr_block() { 
this.frames = [];
var tu_frame = new Image();
tu_loading++;
tu_load_total++;
tu_frame.onload = function() {tu_loading--;};
tu_frame.onerror = function() {tu_loading--;};
tu_frame.src = 'spr_block_0.png';
this.frames.push(tu_frame);
this.width = 40;
this.height = 40;
this.xoffset = 0;
this.yoffset = 0;
this.collision_shape = 'Box';
this.collision_radius = 20;
this.collision_left = 0;
this.collision_right = 40;
this.collision_top = 0;
this.collision_bottom = 40;
};
var spr_block = new __spr_block();
tu_sprites.push(spr_block);
function __spr_diamond() { 
this.frames = [];
var tu_frame = new Image();
tu_loading++;
tu_load_total++;
tu_frame.onload = function() {tu_loading--;};
tu_frame.onerror = function() {tu_loading--;};
tu_frame.src = 'spr_diamond_0.png';
this.frames.push(tu_frame);
this.width = 40;
this.height = 40;
this.xoffset = 20;
this.yoffset = 20;
this.collision_shape = 'Circle';
this.collision_radius = 16;
this.collision_left = 0;
this.collision_right = 40;
this.collision_top = 0;
this.collision_bottom = 40;
};
var spr_diamond = new __spr_diamond();
tu_sprites.push(spr_diamond);
function __spr_bomb() { 
this.frames = [];
var tu_frame = new Image();
tu_loading++;
tu_load_total++;
tu_frame.onload = function() {tu_loading--;};
tu_frame.onerror = function() {tu_loading--;};
tu_frame.src = 'spr_bomb_0.png';
this.frames.push(tu_frame);
this.width = 20;
this.height = 20;
this.xoffset = 10;
this.yoffset = 10;
this.collision_shape = 'Circle';
this.collision_radius = 10;
this.collision_left = 0;
this.collision_right = 20;
this.collision_top = 0;
this.collision_bottom = 20;
};
var spr_bomb = new __spr_bomb();
tu_sprites.push(spr_bomb);


/***********************************************************************
 * SOUNDS
 ***********************************************************************/


/***********************************************************************
 * MUSICS
 ***********************************************************************/


/***********************************************************************
 * BACKGROUNDS
 ***********************************************************************/


/***********************************************************************
 * FONTS
 ***********************************************************************/


/***********************************************************************
 * OBJECTS
 ***********************************************************************/
function __obj_player() {
__instance_init__(this, obj_player, null, 1, 0, spr_player, 1, 0);
this.creation_overwritten = 0;
this.__creation__ = function() {
};
this.step_overwritten = 1;
this.__step__ = function() {
with(this) {

// WHEN THE RIGHT ARROW IS PUSHED
// MOVES THE PLAYER TO THE RIGHT
if ( keyboard_check( vk_right )) {
	x = x + 5;
}

// WHEN THE LEFT ARROW IS PUSHED
// MOVES THE PLAYER TO THE LEFT
if ( keyboard_check( vk_left )) {
	x = x - 5;
}

// WHEN THE UP ARROW IS PUSHED
// MOVES THE PLAYER TO UP
if ( keyboard_check( vk_up )) {
	y = y - 5;
}

// WHEN THE DOWN ARROW IS PUSHED
// MOVES THE PLAYER TO DOWN
if ( keyboard_check( vk_down )) {
	y = y + 5;
}

// WHEN PLAYER PRESSES THE SPACE
// CREATE A NEW BOMB 20 PIXEL LEFT TO THE PLAYER'S POSITION

if ( keyboard_check_pressed( vk_space )) {
	new_bomb = instance_create( x + 20, y, obj_bomb );
}
}
};
this.collision_overwritten = 1;
this.__collision__ = function() {
with(this) {
this.other = this.place_meeting(this.x, this.y, obj_block);
if(this.other != null) {

// STOP THE PLAYER IF HITS THE BLOCK
// PLACE BACK TO ITS PREVIOUS POSITION

x = xprevious;
y = yprevious;
}
}
};
this.end_step_overwritten = 0;
this.__end_step__ = function() {
};
this.draw_overwritten = 0;
this.__draw__ = function() {
if (this.visible == 1) {
__handle_sprite__(this);
draw_sprite_ext(this.sprite_index, this.image_index, this.x, this.y, this.image_xscale, this.image_yscale, this.image_angle, this.image_alpha);
}
};
this.animation_end_overwritten = 0;
this.__animationend__ = function() {
};
this.destroy_overwritten = 0;
this.__destroy__ = function() {
};
};
var obj_player = new __obj_player();
function __obj_block() {
__instance_init__(this, obj_block, null, 1, 0, spr_block, 1, 2);
this.creation_overwritten = 0;
this.__creation__ = function() {
};
this.step_overwritten = 0;
this.__step__ = function() {
};
this.collision_overwritten = 0;
this.__collision__ = function() {
};
this.end_step_overwritten = 0;
this.__end_step__ = function() {
};
this.draw_overwritten = 0;
this.__draw__ = function() {
if (this.visible == 1) {
__handle_sprite__(this);
draw_sprite_ext(this.sprite_index, this.image_index, this.x, this.y, this.image_xscale, this.image_yscale, this.image_angle, this.image_alpha);
}
};
this.animation_end_overwritten = 0;
this.__animationend__ = function() {
};
this.destroy_overwritten = 0;
this.__destroy__ = function() {
};
};
var obj_block = new __obj_block();
function __obj_diamond() {
__instance_init__(this, obj_diamond, null, 1, 0, spr_diamond, 1, 19);
this.creation_overwritten = 0;
this.__creation__ = function() {
};
this.step_overwritten = 0;
this.__step__ = function() {
};
this.collision_overwritten = 1;
this.__collision__ = function() {
with(this) {
this.other = this.place_meeting(this.x, this.y, obj_player);
if(this.other != null) {

// WHEN THE DIAMOND HITS THE PLAYER
// REMOVE FROM THE LEVEL

instance_destroy();
}
}
};
this.end_step_overwritten = 0;
this.__end_step__ = function() {
};
this.draw_overwritten = 0;
this.__draw__ = function() {
if (this.visible == 1) {
__handle_sprite__(this);
draw_sprite_ext(this.sprite_index, this.image_index, this.x, this.y, this.image_xscale, this.image_yscale, this.image_angle, this.image_alpha);
}
};
this.animation_end_overwritten = 0;
this.__animationend__ = function() {
};
this.destroy_overwritten = 0;
this.__destroy__ = function() {
};
};
var obj_diamond = new __obj_diamond();
function __obj_bomb() {
__instance_init__(this, obj_bomb, null, 1, 0, spr_bomb, 1, 23);
this.creation_overwritten = 1;
this.__creation__ = function() {
with(this) {

// SET A NEW VARIABLE CALLED: TIMER
// THIS TIMER WILL COUNT BACK TO 0
this.timer = 200;
}
};
this.step_overwritten = 1;
this.__step__ = function() {
with(this) {

// ROTATE THE IMAGE ANGLE
image_angle = image_angle + 1;

// DECREASE THE TIMER
timer = timer - 1;

// CHECK IF TIMER IS ZERO
// DELETE THE BOMB WHEN ZERO
if ( timer <= 0 ) {
	instance_destroy();
}
}
};
this.collision_overwritten = 0;
this.__collision__ = function() {
};
this.end_step_overwritten = 0;
this.__end_step__ = function() {
};
this.draw_overwritten = 0;
this.__draw__ = function() {
if (this.visible == 1) {
__handle_sprite__(this);
draw_sprite_ext(this.sprite_index, this.image_index, this.x, this.y, this.image_xscale, this.image_yscale, this.image_angle, this.image_alpha);
}
};
this.animation_end_overwritten = 0;
this.__animationend__ = function() {
};
this.destroy_overwritten = 0;
this.__destroy__ = function() {
};
};
var obj_bomb = new __obj_bomb();


/***********************************************************************
 * SCENES
 ***********************************************************************/
function __test_level() { 
this.tiles = [
];
this.objects = [
[obj_player,320,220],
[obj_block,400,280],
[obj_block,400,240],
[obj_block,400,200],
[obj_block,400,160],
[obj_block,400,120],
[obj_block,200,120],
[obj_block,200,160],
[obj_block,200,200],
[obj_block,200,240],
[obj_block,200,280],
[obj_block,240,280],
[obj_block,280,280],
[obj_block,360,280],
[obj_block,320,280],
[obj_block,240,120],
[obj_block,360,120],
[obj_diamond,220,80],
[obj_diamond,420,80],
[obj_diamond,320,80],
];
this.start = function() {
_$_('tululoogame').innerHTML = "<canvas id='test_level_canvas' width='640' height='480' style='background-color:rgb(200,200,200);border-style:solid;border-width:1px;border-color:rgb(200,200,200);'></canvas>";
tu_context = _$_('test_level_canvas').getContext('2d');
tu_canvas = _$_('test_level_canvas');
room_current = test_level;
room_speed = 60;
room_background = null
room_width = 640;
room_height = 480;
room_background_color_red = 46;
room_background_color_green = 90;
room_background_color_blue = 65;
room_background_tile_x = 0;
room_background_tile_y = 0;
room_background_tile_stretch = 0;
room_viewport_width = 640;
room_viewport_height = 480;
room_viewport_x = 0;
room_viewport_y = 0;
room_viewport_object = null;
room_viewport_hborder = 50;
room_viewport_vborder = 50;
var _tls_ = this.tiles;
tu_tiles = [];
tu_tilesi = [];
tu_depth = [];
tu_depthi = [];
tu_types = [];
for (var _l = 0; _l < _tls_.length; _l++) {
for (var _b = 1; _b < _tls_[_l].length; _b++) {
for (var _t = 1; _t < _tls_[_l][_b].length; _t++) {tile_add(_tls_[_l][_b][0],_tls_[_l][_b][_t][0],_tls_[_l][_b][_t][1],_tls_[_l][_b][_t][2],_tls_[_l][_b][_t][3],_tls_[_l][_b][_t][4],_tls_[_l][_b][_t][5],_tls_[_l][0]);}
}
};
tu_objects = [];
for (var _i = 0, _il = this.objects.length; _i < _il; _i++) {
tu_obj = new this.objects[_i][0].constructor;
tu_obj.object_index = this.objects[_i][0];
tu_obj.x = this.objects[_i][1];
tu_obj.y = this.objects[_i][2];
tu_obj.xprevious = this.objects[_i][1];
tu_obj.yprevious = this.objects[_i][2];
tu_obj.xstart = this.objects[_i][1];
tu_obj.ystart = this.objects[_i][2];
tu_type_add(tu_obj._object_index, tu_obj);
if (tu_obj.parent != null) tu_type_add(tu_obj.parent, tu_obj);
tu_obj.depth = tu_obj.depthstart;
tu_obj.parent != null && tu_obj.creation_overwritten == 0 ? tu_obj.parent.__creation__.call(tu_obj) : tu_obj.__creation__();
}
};
}
var test_level = new __test_level();
tu_scenes.push(test_level);
tu_room_to_go = test_level;


/***********************************************************************
 * CUSTOM GLOBAL VARIABLES
 ***********************************************************************/


/***********************************************************************
 * CUSTOM GLOBAL FUNCTIONS
 ***********************************************************************/


var __gameloop__ = tu_loop;
tu_loop();
